<?php

/**
 * Template part for displaying the page content when an error has occurred
 *
 * @package signocore-toolkit
 * @since 1.0.0
 */

use SignocoreToolkit\Application\Constants;
use SignocoreToolkit\Support\FAQHelper;
use SignocoreToolkit\Support\GlossaryHelper;
use SignocoreToolkit\Support\TaxonomyHelper;

?>
<section class="error">
	<div class="page-content">
		<?php
		$object = get_queried_object();
		$hasContent = TaxonomyHelper::hasContent();
		$hasRelatedContent = TaxonomyHelper::hasRelatedContent($object);

		if (is_tag()) {
			if ($hasRelatedContent) {
				if ($hasContent) {
				?>
					<h2><?php esc_html_e("Related Content", Constants::TEXT_DOMAIN); ?></h2>
				<?php
				} else {
				?>
					<p><?php esc_html_e("It seems we can't find any posts in this archive. Yet, we have some related content that might interest you or you can try searching for something else.", Constants::TEXT_DOMAIN); ?></p>
				<?php
					get_search_form();
				}

				if (defined('SIGNOCORE_GLOSSARY_VERSION')) {
					$glossaryTermsByTitle = GlossaryHelper::termsByTitle($object->name);
					$glossaryTermsByTags = GlossaryHelper::termsByTags([$object->slug], 10, array_map(fn($term) => $term->ID, $glossaryTermsByTitle));
					$glossaryTerms = array_merge($glossaryTermsByTitle, $glossaryTermsByTags);
					usort($glossaryTerms, function ($a, $b) {
						$aViews = get_post_meta($a->ID, 'page_views', true) ?: 0;
						$bViews = get_post_meta($b->ID, 'page_views', true) ?: 0;
						return $bViews <=> $aViews;
					});
					$glossaryTerms = array_slice($glossaryTerms, 0, 10);

					if (!empty($glossaryTerms)) {
						echo GlossaryHelper::render($glossaryTerms, sprintf(__('Terms related to %s', Constants::TEXT_DOMAIN), $object->name), 'related-words');
					}
				}

				if (defined('SIGNOCORE_FAQ_VERSION')) {
					$faqs = FAQHelper::faqsByTags([$object->slug], 10);
					if (!empty($faqs)) {
						echo FAQHelper::render($faqs, sprintf(__('Questions related to %s', Constants::TEXT_DOMAIN), $object->name), 'related-questions');
					}
				}
			} else {
				?>
				<p><?php esc_html_e("It seems we can't find any posts in this archive. Perhaps searching can help.", Constants::TEXT_DOMAIN); ?></p>
			<?php
				get_search_form();
			}
		} else {
			?>
			<p><?php esc_html_e("It seems we can't find any content in this archive. Perhaps searching can help.", Constants::TEXT_DOMAIN); ?></p>
		<?php
			get_search_form();
		}
		?>
	</div><!-- .page-content -->
</section><!-- .error -->