<?php

declare(strict_types=1);

namespace SignocoreToolkit\Support;

class FAQHelper
{
    /**
     * @param array<int, string> $slugs
     * @return array<int, \WP_Post>
     */
    public static function faqsByTags(array $slugs, int $numberPosts = 10): array
    {
        return get_posts([
            'post_type' => 'wpsseo_faq',
            'post_status' => 'publish',
            'numberposts' => $numberPosts,
            'suppress_filters' => false,
            'no_found_rows'          => true,
            'ignore_sticky_posts'    => true,
            'update_post_meta_cache' => false,
            'tax_query' => [
                [
                    'taxonomy' => 'post_tag',
                    'field' => 'slug',
                    'terms' => $slugs,
                ]
            ]
        ]);
    }

    /**
     * @param array<int, \WP_Post> $faqs
     */
    public static function render(array $faqs, string $title = '', string $class = 'faqs'): string
    {
        if ($faqs === []) {
            return '';
        }

        $output = '<div class="' . esc_attr($class) . '">';
        if ($title !== '' && $title !== '0') {
            $output .= '<h3>' . esc_html($title) . '</h3>';
        }

        $output .= '<ul>';
        foreach ($faqs as $faq) {
            $output .= '<li><a href="' . esc_url((string) get_permalink($faq->ID)) . '">' . esc_html($faq->post_title) . '</a></li>';
        }

        return $output . '</ul></div>';
    }
}
