<?php

declare(strict_types=1);

namespace SignocoreToolkit\Support;

class DomainHelper
{
	public static function isOnline(string $url, int $timeout = 2, int $customPort = 0): bool
	{
		if ($customPort > 0) {
			$port = $customPort;
		} else {
			$scheme = strtolower((string) parse_url($url, PHP_URL_SCHEME));
			$port = $scheme === 'http' ? 80 : ($scheme === 'ftp' ? 21 : ($scheme === 'ssh' ? 22 : 443));
		}

		$host = strtolower((string) parse_url($url, PHP_URL_HOST));

		if ($socket = @fsockopen($host, $port, $errno, $errstr, $timeout)) {
			fclose($socket);
			return true;
		}

		return false;
	}

	public static function validateIp(string $ip): string|false
	{
		return filter_var($ip, FILTER_VALIDATE_IP);
	}

	public static function validateDomain(string $domain): string|false
	{
		return filter_var($domain, FILTER_VALIDATE_DOMAIN);
	}
}
