<?php

declare(strict_types=1);

namespace SignocoreToolkit\Support;

use SignocoreToolkit\Application\Constants;

class Debug
{
	public static function pre(mixed $obj, bool $die = false): void
	{
		echo '<pre>' . print_r($obj, true) . '</pre>';
		if ($die) {
            die;
        }
	}

	public static function dump(mixed $obj, bool $die = false): void
	{
		ob_start();
		var_dump($obj);
		$dump = ob_get_clean() ?: '';

		if (str_contains($dump, 'xdebug-var-dump')) {
			echo $dump;
		} else {
			echo '<pre>' . $dump . '</pre>';
		}

		if ($die) {
            die;
        }
	}

	public static function dd(mixed ...$obj): void
	{
		foreach ($obj as $item) {
			self::dump($item);
		}

		die;
	}

	/**
     * @return array<string, mixed>
     */
    public static function benchmark(callable $fn, mixed ...$args): array
	{
		$start = microtime(true);
		$data = call_user_func_array($fn, $args);
		$end = microtime(true);

		return [
			'data' => $data,
			'request_start' => $start,
			'request_end' => $end,
			'seconds_elapsed' => round($end - $start, 4),
		];
	}

	public static function enableEnvironmentDebugging(): void
	{
		add_action('parse_request', [self::class, 'maybeEnableDebugging']);
	}

	public static function maybeEnableDebugging(): void
	{
		if (Constants::$isAdmin || defined('DOING_AJAX')) {
			return;
		}

		if (!Constants::$isPublic || wp_get_environment_type() !== 'production') {
			@ini_set('display_errors', '1');
			@ini_set('max_execution_time', '0');
			@ini_set('memory_limit', '2048M');
			error_reporting(E_ALL);
			set_time_limit(0);
		}
	}
}
