<?php

declare(strict_types=1);

namespace SignocoreToolkit\Infrastructure\Traits;

/**
 * Singleton pattern implementation for WordPress plugin services.
 *
 * @package SignocoreToolkit\Infrastructure\Traits
 * @since 1.0.0
 */
trait Singleton
{
	/** @var static|null */
	protected static ?self $instance = null;

	/**
	 * Get or create the singleton instance.
	 *
	 * @return static The singleton instance
	 */
	final public static function load(): static
	{
		if (static::$instance === null) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	/**
	 * Private constructor prevents direct instantiation.
	 */
	private function __construct()
	{
		$this->init();
	}

	/**
	 * Initialization method for subclasses to override.
	 */
	protected function init(): void {}

	/**
	 * Prevent cloning of the singleton instance.
	 */
	final public function __clone(): void {}

	/**
	 * Prevent unserializing of the singleton instance.
	 */
	final public function __wakeup(): void {}
}
