<?php

declare(strict_types=1);

namespace SignocoreToolkit\Features;

use SignocoreToolkit\Infrastructure\Traits\Singleton;
use SignocoreToolkit\Application\Constants;

final class Security
{
	use Singleton;

	protected function init(): void
	{
		remove_action('wp_head', 'wp_oembed_add_discovery_links');
		remove_filter('oembed_dataparse', 'wp_filter_oembed_result', 10);
		remove_action('rest_api_init', 'wp_oembed_register_route');
		remove_action('template_redirect', 'rest_output_link_header', 11);

		remove_filter('wp_mail', 'wp_staticize_emoji_for_email');
		remove_filter('comment_text_rss', 'wp_staticize_emoji');
		remove_filter('the_content_feed', 'wp_staticize_emoji');

		add_filter('auto_update_core', '__return_true');
		add_filter('auto_update_plugin', '__return_true');
		add_filter('auto_update_theme', '__return_true');
		add_filter('auto_update_translation', '__return_true');
		add_filter('json_enabled', '__return_false');
		add_filter('json_jsonp_enabled', '__return_false');
		add_filter('tiny_mce_plugins', [$this, 'disableEmojisTinymce']);
		add_filter('auto_core_update_send_email', [$this, 'limitUpdateEmails'], 10, 4);
		add_filter('login_errors', [$this, 'loginErrors']);
	}

	/**
	 * @param array<int, string> $plugins
	 * @return array<int, string>
	 */
	public function disableEmojisTinymce(array $plugins): array
	{
		return array_diff($plugins, ['wpemoji']);
	}

	public function limitUpdateEmails(bool $send, string $type, object $coreUpdate, object $result): bool
    {
        return $type === 'fail' || $type === 'critical';
    }

	public function loginErrors(string $error): string
	{
		if (isset($_GET['action'])) {
			return $error;
		}

		global $errors;
		$errorCodes = $errors->get_error_codes();

		if (in_array('invalid_username', $errorCodes) || in_array('empty_username', $errorCodes) || in_array('incorrect_password', $errorCodes) || in_array('empty_password', $errorCodes)) {
			return _x('Invalid login credentials.', 'Login error', Constants::TEXT_DOMAIN);
		}

		return $error;
	}
}
