<?php

declare(strict_types=1);

namespace SignocoreToolkit\Features;

use SignocoreToolkit\Infrastructure\Traits\Singleton;
use SignocoreToolkit\Admin\Login;

final class Mail
{
	use Singleton;

	protected function init(): void
	{
		if (Login::isLoginPage()) {
			add_filter('wp_mail_from', [$this, 'wpMailSenderEmail']);
			add_filter('wp_mail_from_name', [$this, 'wpMailSenderName']);
		}

		$this->disableAdminVerificationUrl();

		add_filter('wp_mail_content_type', [$this, 'wpMailContentType']);
		add_filter('admin_email_check_interval', '__return_false');
	}

	public function wpMailContentType(): string
	{
		return 'text/html';
	}

	public function wpMailSenderEmail(): string
	{
		return get_option('wpsseo_company_email', get_option('admin_email'));
	}

	public function wpMailSenderName(): string
	{
		return get_option('wpsseo_company_name', get_bloginfo('name'));
	}

	public function disableAdminVerificationUrl(): void
	{
		$redirectTo = sanitize_url(wp_unslash($_GET['redirect_to'] ?? ''));
		$action = wp_unslash($_GET['action'] ?? '');

		if (!empty($redirectTo) && $action === 'confirm_admin_email') {
			wp_redirect($redirectTo);
			exit;
		}
	}

	public static function emailToEntities(string $email): string
	{
		$chars = str_split($email);
		$returnEmail = '';

		foreach ($chars as $char) {
			$returnEmail .= '&#' . ord($char) . ';';
		}

		return $returnEmail;
	}
}
