<?php

declare(strict_types=1);

namespace SignocoreToolkit\Features;

use SignocoreToolkit\Infrastructure\Traits\Singleton;
use SignocoreToolkit\Application\Constants;

final class Kadence
{
    use Singleton;

    protected function init(): void
    {
        add_action('kadence_after_header', [$this, 'addSignocoreBreadcrumbs']);
        add_action('kadence_archive_after_entry_header', [$this, 'addBlogPageContent']);
        add_action('kadence_archive_after_entry_header', [$this, 'addArchiveContent']);
        add_action('kadence_after_main_content', [$this, 'addArchiveAdditionalContent']);
        add_filter('kadence_breadcrumb_html', '__return_empty_string');
    }

    public function addSignocoreBreadcrumbs(): void
    {
        $breadcrumbs = '[signocore-breadcrumbs]';
        $breadcrumbsParsed = apply_shortcodes($breadcrumbs);

        if ($breadcrumbsParsed !== '' && $breadcrumbsParsed !== $breadcrumbs) {
            echo '<div class="breadcrumbs-wrapper">';
            echo $breadcrumbsParsed;
            echo '</div>';
        }
    }

    public function addBlogPageContent(): void
    {
        if (is_home() && !is_paged()) {
            $blogPageId = get_option('page_for_posts');
            if ($blogPageId) {
                $blogPageContent = apply_filters('the_content', get_post_field('post_content', $blogPageId));
                echo '<div class="blog-page-content">' . $blogPageContent . '</div>';
            }
        }
    }

    private function getAuthorImage(): string
    {
        $ppDisabled = (bool) get_user_meta((int) get_the_author_meta('ID'), 'pp_disabled', true);
        if (!$ppDisabled) {
            return (string) get_avatar(get_the_author_meta('email'), 148, 'mm', get_the_author());
        }

        return '';
    }

    public function addArchiveContent(): void
    {
        $image = '';
        $separator = '';
        if (is_author()) {
            $image = $this->getAuthorImage();
            $separator = '<hr><h2>' . __('Blog Posts', Constants::TEXT_DOMAIN) . '</h2>';
        }

        if (is_archive()) {
            $objectId = get_queried_object_id();
            $archiveDescription = is_author() ? get_user_meta($objectId, 'intro_text', true) : get_term_meta($objectId, 'intro_text', true);

            if ($archiveDescription) {
                echo '<div class="archive-description">';
                echo $image;
                echo apply_filters('the_content', $archiveDescription);
                echo $separator;
                echo '</div>';
            }
        }
    }

    public function addArchiveAdditionalContent(): void
    {
        if (is_archive()) {
            $objectId = get_queried_object_id();
            $additionalDescription = is_author() ? get_user_meta($objectId, 'additional_intro_text', true) : get_term_meta($objectId, 'additional_intro_text', true);

            if ($additionalDescription) {
                echo '<div class="archive-additional-description">' . apply_filters('the_content', $additionalDescription) . '</div>';
            }
        }
    }
}
