<?php

declare(strict_types=1);

namespace SignocoreToolkit\Features\DevTools\Traits;

use SignocoreToolkit\Application\Constants;

/**
 * Provides tab navigation for DevTools pages.
 *
 * @package SignocoreToolkit\Features\DevTools\Traits
 * @since 3.0.0
 */
trait HasDevToolsTabs
{
	/**
	 * Render main plugin tabs with Dev Tools marked as active.
	 *
	 * Uses wpsseo-tabs styling from signocore-seo plugin for consistency.
	 */
	protected function renderMainTabs(): void
	{
		$tabs = [
			'signocore-toolkit-settings' => __('General', Constants::TEXT_DOMAIN),
			'signocore-toolkit-blog' => __('Blog', Constants::TEXT_DOMAIN),
			'signocore-toolkit-social' => __('Social', Constants::TEXT_DOMAIN),
		];

		// Add Shop tab only if WooCommerce is active
		if (Constants::$isWooCommerce) {
			$tabs['signocore-toolkit-shop'] = __('Shop', Constants::TEXT_DOMAIN);
		}

		$tabs['signocore-toolkit-devtools'] = __('Dev Tools', Constants::TEXT_DOMAIN);

		echo '<h2 class="nav-tab-wrapper wpsseo-tabs">';
		foreach ($tabs as $slug => $label) {
			// Dev Tools is always active on these pages
			$isActive = ($slug === 'signocore-toolkit-devtools');
			$class = $isActive ? 'nav-tab nav-tab-active' : 'nav-tab';
			$url = admin_url('admin.php?page=' . $slug);
			printf(
				'<a href="%s" class="%s">%s</a>',
				esc_url($url),
				esc_attr($class),
				esc_html($label)
			);
		}
		echo '</h2>';
	}

	/**
	 * Render DevTools sub-tabs with secondary styling.
	 *
	 * @param string $currentPage The current page slug.
	 */
	protected function renderDevToolsTabs(string $currentPage): void
	{
		$tabs = [
			'signocore-toolkit-devtools' => __('Settings', Constants::TEXT_DOMAIN),
			'signocore-toolkit-mail-log' => __('Mail Log', Constants::TEXT_DOMAIN),
			'signocore-toolkit-transients' => __('Transients', Constants::TEXT_DOMAIN),
			'signocore-toolkit-cron' => __('Cron Jobs', Constants::TEXT_DOMAIN),
			'signocore-toolkit-status' => __('System Status', Constants::TEXT_DOMAIN),
		];

		echo '<div class="sctk-subtabs">';
		foreach ($tabs as $slug => $label) {
			$class = ($currentPage === $slug) ? 'sctk-subtab sctk-subtab-active' : 'sctk-subtab';
			$url = admin_url('admin.php?page=' . $slug);
			printf(
				'<a href="%s" class="%s">%s</a>',
				esc_url($url),
				esc_attr($class),
				esc_html($label)
			);
		}
		echo '</div>';
	}
}
