<?php

declare(strict_types=1);

namespace SignocoreToolkit\Application;

use SignocoreToolkit\Infrastructure\Traits\Singleton;

final class SignocoreToolkit
{
    use Singleton;

    public string $color = '#b8642a';

    protected function init(): void
    {
        add_action('init', [$this, 'loadTranslations'], 0);
        add_filter('plugin_action_links_' . Constants::$pluginBase, [$this, 'actionLinks']);
        add_filter('plugin_row_meta', [$this, 'metaLinks'], 10, 2);

        ServiceRegistry::boot();
    }

    public function loadTranslations(): void
    {
        load_plugin_textdomain(Constants::TEXT_DOMAIN, false, Constants::TEXT_DOMAIN . '/languages/');
    }

    /**
     * @param array<string, mixed> $links
     * @return array<int|string, mixed>
     */
    public function actionLinks(array $links): array
    {
        $links['deactivate'] = str_replace('<a ', '<a style="color: #777;" ', $links['deactivate']);
        $links[] = '<a href="' . esc_url(admin_url('admin.php?page=signocore-toolkit-settings')) . '" style="color: ' . esc_attr($this->color) . ';" aria-label="' . esc_attr__('Signocore Toolkit Settings', Constants::TEXT_DOMAIN) . '">' . esc_html__('Settings', Constants::TEXT_DOMAIN) . '</a>';

        return $links;
    }

    /**
     * @param array<string, string> $pluginMeta
     * @return array<int|string, string>
     */
    public function metaLinks(array $pluginMeta, string $pluginFile): array
    {
        if ($pluginFile === Constants::$pluginBase) {
            return [
                sprintf(esc_html__('Version %s', Constants::TEXT_DOMAIN), esc_html(Constants::$pluginVersion)),
                sprintf(
                    esc_html__('By %s', Constants::TEXT_DOMAIN),
                    '<a href="https://signocore.com/" target="_blank" rel="noopener" style="color: ' . esc_attr($this->color) . ';" aria-label="' . esc_attr__('Signocore Website', Constants::TEXT_DOMAIN) . '">Signocore</a>'
                ),
                '<a href="https://signocore.com/wordpress-plugins/" target="_blank" rel="noopener" style="color: ' . esc_attr($this->color) . ';" aria-label="' . esc_attr__('Signocore Plugins', Constants::TEXT_DOMAIN) . '">' . esc_html__('Premium Plugins', Constants::TEXT_DOMAIN) . '</a>',
                '<a href="https://signocore.com/kontakt/" target="_blank" rel="noopener" style="color: ' . esc_attr($this->color) . ';" aria-label="' . esc_attr__('Contact Signocore', Constants::TEXT_DOMAIN) . '">' . esc_html__('Contact Us', Constants::TEXT_DOMAIN) . '</a>'
            ];
        }

        return $pluginMeta;
    }
}
