<?php

declare(strict_types=1);

namespace SignocoreToolkit\Admin;

use SignocoreToolkit\Infrastructure\Traits\Singleton;
use SignocoreToolkit\Application\Constants;

final class Login
{
	use Singleton;

	protected function init(): void
	{
		add_action('login_enqueue_scripts', [$this, 'customStyles']);
		add_filter('login_headerurl', [$this, 'customLoginUrl']);
		add_filter('login_headertext', [$this, 'customUrlTitle']);
		add_filter('login_display_language_dropdown', '__return_false');
		add_action('wp_print_scripts', [$this, 'removeStrengthMeter'], 100);
		add_action('login_footer', [$this, 'addImage']);
		add_action('login_form', [$this, 'addPassReset']);
		add_action('login_form', [$this, 'addIntroText']);
	}

	public function addPassReset(): void
	{
		echo '<p class="lost-password"></p>';
	}

	public function addIntroText(): void
	{
		echo '<div id="login-intro">
			<p>' . esc_html__('Please enter your email address and password to log in.', Constants::TEXT_DOMAIN) . '</p>
		</div>';
	}

	public function addImage(): void
	{
		echo '<div id="login-image"></div>';
		echo '<div class="signocore-loader"><div class="signocore-spinner"></div><span class="signocore-loader-content">' . esc_html__("We're working - Please wait...", Constants::TEXT_DOMAIN) . '</span></div>';
	}

	public static function isLoginPage(): bool
	{
		$uri = $_SERVER['REQUEST_URI'] ?? '/';
		$uri = htmlspecialchars($uri, ENT_QUOTES, 'UTF-8');
        return $GLOBALS['pagenow'] == 'wp-login.php' || stripos($uri, 'wp-login.php') !== false;
	}

	public function removeStrengthMeter(): void
	{
		wp_dequeue_script('wc-password-strength-meter');
	}

	public function customStyles(): void
	{
		$cdnjs = 'https://cdnjs.cloudflare.com/ajax/libs';

		wp_enqueue_script('jquery');
		wp_enqueue_style('font-awesome', $cdnjs . '/font-awesome/6.5.1/css/all.min.css');
		wp_enqueue_style('signocore-login', Constants::$assetsUri . '/css/login.min.css', [], Constants::$pluginVersion);
		wp_enqueue_script('signocore-login', Constants::$assetsUri . '/js/login.min.js', ['jquery']);

		echo '<style type="text/css">
			#login-image{
				background: url(' . esc_url(Constants::$assetsUri . '/img/login-bg.jpg') . ') no-repeat right top / cover !important;
			}
			body.login #login h1 a{
				background-image: url(' . esc_url(Constants::$assetsUri . '/img/signocore-logo.png') . ') !important;
			}
		</style>';
	}

	public function customLoginUrl(): string
	{
		return 'https://signocore.com/';
	}

	public function customUrlTitle(): string
	{
		return __('Signocore SEO', Constants::TEXT_DOMAIN);
	}
}
